/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.text2speech;

import java.io.File;
import java.io.FileInputStream;
import java.nio.Buffer;
import java.util.function.Consumer;
import libsidplay.config.IAudioSection;
import libsidplay.config.ISidPlay2Section;
import libsidutils.AudioUtils;
import server.restful.common.text2speech.TextToSpeechBean;
import server.restful.common.text2speech.TextToSpeechType;
import sidplay.Player;

public class TextToSpeech
implements Consumer<Player> {
    private TextToSpeechType textToSpeechType;
    private TextToSpeechBean textToSpeechBean;

    public TextToSpeech(TextToSpeechType textToSpeechType, TextToSpeechBean textToSpeechBean) {
        this.textToSpeechType = textToSpeechType;
        this.textToSpeechBean = textToSpeechBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Player player) {
        File wavFile = null;
        try {
            ISidPlay2Section sidplay2Section = player.getConfig().getSidplay2Section();
            IAudioSection audioSection = player.getConfig().getAudioSection();
            wavFile = File.createTempFile("text2speech", ".wav", sidplay2Section.getTmpDir());
            this.textToSpeechBean.setVolume(audioSection.getMainVolume());
            this.textToSpeechType.createProcess(this.textToSpeechBean, wavFile);
            try (FileInputStream is = new FileInputStream(wavFile);){
                short[] samples;
                for (short sample : samples = AudioUtils.convertToMonoWithSampleRate(is, Integer.MAX_VALUE, audioSection.getSamplingRate())) {
                    player.getAudioDriver().buffer().putShort(sample);
                    if (player.getAudioDriver().buffer().putShort(sample).hasRemaining()) continue;
                    player.getAudioDriver().write();
                    ((Buffer)player.getAudioDriver().buffer()).clear();
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Error during Text2Speech! Install or deactivate it!? (apt-get install espeak or sudo apt install libttspico-utils)\n" + e.getMessage());
        }
        finally {
            if (wavFile != null) {
                wavFile.delete();
            }
        }
    }
}

